CREATE OR REPLACE FUNCTION util.recreate_imap_chains(
    i_uid         code.uid,
    i_fid         code.fid,
    i_chain_size  smallint
) RETURNS void AS $$
DECLARE
    rev_as_lock bigint := code.acquire_current_revision(i_uid);
BEGIN
    UPDATE mail.box
       SET chain = NULL
     WHERE uid = i_uid
       AND fid = i_fid
       AND chain is not NULL;

    WITH chained_box AS (
        SELECT * FROM (
            SELECT c.*,
                   max(imap_rownum) OVER() AS max_imap_rownum
              FROM (
                SELECT uid,
                       fid,
                       imap_id,
                       row_number() OVER (ORDER BY imap_id) AS imap_rownum
                  FROM mail.box
                 WHERE uid = i_uid
                   AND fid = i_fid) c ) sb
             WHERE imap_rownum % i_chain_size = 1
    )
    UPDATE mail.box ub
       SET chain = least(i_chain_size, max_imap_rownum - imap_rownum + 1)
      FROM chained_box sb
     WHERE ub.uid = sb.uid
       AND ub.imap_id = sb.imap_id
       AND ub.fid = sb.fid;
END;
$$ LANGUAGE plpgsql;
