CREATE OR REPLACE FUNCTION util.restore_deleted_message(
    i_uid         code.uid,
    i_deleted_mid code.mid,
    i_fid         code.fid
) RETURNS util.restore_result AS $$
DECLARE
    deleted_info          jsonb;
    messages_row          mail.messages;
    references_hashes     numeric[];
    in_reply_to_hash      numeric;
    new_mid               bigint;
    casted_recipients     code.store_recipient[];
BEGIN
    SELECT db.info
      INTO deleted_info
      FROM mail.deleted_box db
     WHERE uid = i_uid
       AND mid = i_deleted_mid;

    SELECT *
      INTO messages_row
      FROM mail.messages
     WHERE uid = i_uid
       AND mid = i_deleted_mid;

    IF deleted_info IS NULL OR messages_row IS NULL THEN
        RETURN (
            i_deleted_mid,
            NULL,
            'No data found in messages or delete_box'
        )::util.restore_result;
    END IF;

    references_hashes := ARRAY(
        SELECT value
          FROM mail.message_references
         WHERE uid = i_uid
           AND mid = i_deleted_mid
           AND type = 'reference'
    );

    SELECT value
      INTO in_reply_to_hash
      FROM mail.message_references
     WHERE uid = i_uid
       AND mid = i_deleted_mid
       AND type = 'in-reply-to';


    casted_recipients := messages_row.recipients;

    SELECT mid
      INTO new_mid
        FROM code.store_message(
      i_uid        := i_uid,
      i_coords     := (
          i_fid,
          impl.get_found_tid(i_uid, i_deleted_mid),
          TRUE, -- seen
          FALSE, -- deleted,
          messages_row.st_id,
          (deleted_info->>'received_date')::timestamp with time zone,
          messages_row.size,
          messages_row.attributes,
          NULL -- pop_uidl
      )::code.store_coordinates,
      i_headers    := (
          messages_row.subject,
          messages_row.firstline,
          messages_row.hdr_date,
          messages_row.hdr_message_id,
          messages_row.extra_data
      )::code.store_headers,
      i_recipients := casted_recipients,
      i_attaches   := util.cast_to_store_attaches(messages_row.attaches),
      i_mime       := messages_row.mime::code.store_mime_part[],
      i_lids       := array[]::int[],
      i_threads    := (
          'force-new-thread',
          references_hashes,
          in_reply_to_hash,
          NULL, -- hash_value
          NULL, -- hash_namespace
          NULL, -- hash_uniq_key,
          NULL  -- sort_options
      )::code.store_threading
    );

    RETURN (
        i_deleted_mid,
        new_mid,
        NULL
    )::util.restore_result;
END;
$$ LANGUAGE plpgsql;
