CREATE OR REPLACE FUNCTION util.fix_chains(i_uid code.uid, current_revision bigint)
    RETURNS void AS $$
DECLARE
    rev_as_lock   bigint := code.acquire_current_revision(i_uid);
    broken_chains jsonb;
BEGIN
    SELECT json_agg(broken)::jsonb
      INTO broken_chains
      FROM code.check_chains(i_uid);

    IF broken_chains IS NOT NULL THEN
        UPDATE mail.box
           SET chain=NULL
         WHERE uid = i_uid;

        PERFORM util.fill_imap_chains(i_uid);

        INSERT INTO mail.fix_log
            (uid, revision, fix_key, fixed)
        VALUES
            (i_uid, current_revision, 'box.chain', broken_chains::jsonb);
    END IF;
END;
$$ LANGUAGE plpgsql;
