CREATE OR REPLACE FUNCTION util.fix_user(i_uid code.uid, i_fixes util.fix[] DEFAULT NULL)
    RETURNS boolean AS $$
DECLARE
    current_revision bigint := code.acquire_current_revision(i_uid);
    icf util.fix[] := i_fixes;
    fix_something boolean;
BEGIN
    IF coalesce(cardinality(icf), 0) = 0 THEN
        icf := enum_range(NULL::util.fix);
    END IF;

    -- set biggest revision
    current_revision := util.fix_revision(i_uid, current_revision);

    IF ARRAY['labels']::util.fix[] && icf THEN
        PERFORM util.fix_labels(i_uid, current_revision);
    END IF;

    IF ARRAY['folders']::util.fix[] && icf THEN
        PERFORM util.fix_folders(i_uid, current_revision);
    END IF;

    -- defaults fix require serials fix
    IF ARRAY['serials', 'defaults']::util.fix[] && icf THEN
        PERFORM util.fix_serials(i_uid, current_revision);
    END IF;

    IF ARRAY['defaults']::util.fix[] && icf THEN
        PERFORM util.fix_defaults(i_uid, current_revision);
    END IF;

    IF ARRAY['chains']::util.fix[] && icf THEN
        PERFORM util.fix_chains(i_uid, current_revision);
    END IF;

    IF ARRAY['doomed']::util.fix[] && icf THEN
        PERFORM util.fix_doomed_layout(i_uid, current_revision);
    END IF;

    IF ARRAY['threaded']::util.fix[] && icf THEN
        PERFORM util.fix_threaded_layout(i_uid);
    END IF;

    IF ARRAY['tabs']::util.fix[] && icf THEN
        PERFORM util.fix_tabs(i_uid, current_revision);
    END IF;

    IF ARRAY['threads_newest_in_folders']::util.fix[] && icf THEN
        PERFORM util.fix_threads_newest_in_folders(i_uid, current_revision);
    END IF;

    IF ARRAY['threads_newest_in_tabs']::util.fix[] && icf THEN
        PERFORM util.fix_threads_newest_in_tabs(i_uid, current_revision);
    END IF;

    IF ARRAY['counters']::util.fix[] && icf THEN
        PERFORM util.fix_counters(i_uid, current_revision);
    END IF;

    IF EXISTS (
        SELECT 1
          FROM mail.fix_log
         WHERE uid = i_uid
           AND revision = current_revision)
    THEN
        PERFORM code.increment_revision(i_uid);
        RETURN true;
    END IF;
    RETURN false;
END;
$$ LANGUAGE plpgsql;
