CREATE OR REPLACE FUNCTION util.fix_not_positive_lids(i_uid code.uid)
    RETURNS void AS $$
DECLARE
    old_label mail.labels;
    new_label mail.labels;
    i_mids    bigint[];
BEGIN
    FOR old_label IN (
        SELECT *
          FROM mail.labels
         WHERE uid = i_uid
           AND lid <= 0
    ) LOOP
        RAISE NOTICE 'old_label %', old_label;
        i_mids := impl.find_mids_by_lid(i_uid, old_label.lid);
        IF cardinality(i_mids) > 0 THEN
            PERFORM code.update_messages(
                i_uid := i_uid,
                i_mids := i_mids,
                set_seen := NULL,
                set_recent := NULL,
                set_deleted := NULL,
                i_lids_add := ARRAY[]::integer[],
                i_lids_del := ARRAY[old_label.lid]
            );
        END IF;
        -- //_-)
        -- can't user code.delete_labels, domain code.lid check for positive lids
        DELETE FROM mail.labels
         WHERE uid = i_uid
           AND lid = old_label.lid;

        new_label := code.create_label(
            i_uid := i_uid,
            i_name := old_label.name,
            i_type := old_label.type,
            i_color := old_label.color
        );
        IF cardinality(i_mids) > 0 THEN
            PERFORM code.update_messages(
                i_uid := i_uid,
                i_mids := i_mids,
                set_seen := NULL,
                set_recent := NULL,
                set_deleted := NULL,
                i_lids_add := ARRAY[new_label.lid],
                i_lids_del := ARRAY[]::integer[]
            );
        END IF;
    END LOOP;
END;
$$ LANGUAGE plpgsql;
