CREATE OR REPLACE FUNCTION util.fix_so_label_types(
    i_uid      code.uid
) RETURNS VOID AS $$
DECLARE
    v_bad_label  mail.labels;
BEGIN
    FOR v_bad_label IN (
        SELECT *
          FROM mail.labels
         WHERE uid = i_uid
           AND type = 'domain'
           AND name ~ '^\d+$'
    ) LOOP
        PERFORM util.change_label_type(
            i_uid,
            v_bad_label,
            'type'
        );
    END LOOP;
END;
$$ LANGUAGE plpgsql;