CREATE OR REPLACE FUNCTION util.merge_tm_into_messages(i_uid code.uid)
    RETURNS void AS $$
UPDATE mail.messages m
   SET found_tid = nm.found_tid,
       thread_rule = nm.thread_rule
  FROM (
    SELECT im.mid,
           coalesce(im.found_tid, tm.tid, im.mid) AS found_tid,
           coalesce(
            im.thread_rule,
            tm.rule,
            'undefined'::mail.threads_merge_rules) AS thread_rule
      FROM mail.messages im
      LEFT JOIN mail.threads_messages tm
     USING (uid, mid)
     WHERE im.uid = i_uid
       AND (im.found_tid IS NULL OR im.thread_rule IS NULL)) nm
 WHERE m.uid = i_uid
   AND m.mid = nm.mid;
$$ LANGUAGE sql;