CREATE OR REPLACE FUNCTION util.remove_recipient_brackets(
    i_uid code.uid
) RETURNS void AS $$
DECLARE
BEGIN
    UPDATE mail.messages
    SET recipients = new_rcpts FROM (
        SELECT mid AS sub_mid, array_agg(((rcpts).type, (rcpts).name, trim(trailing '>' from trim(leading '<' from (rcpts).email)))::mail.recipient) AS new_rcpts
        FROM (
            SELECT uid, mid, unnest(recipients) AS rcpts FROM mail.messages
        ) as rcpts_table
        WHERE uid = i_uid
        GROUP BY mid
    ) new_rcpts_table
    WHERE uid = i_uid AND mid = sub_mid;
END;
$$ LANGUAGE plpgsql;

