CREATE OR REPLACE FUNCTION util.fill_changelog_for_msearch(
    i_uid   code.uid
) RETURNS bigint AS $$
DECLARE
    rc bigint;
    i_chunk_size constant real := util.search_chunk_size();
BEGIN

    INSERT INTO mail.change_log
        (uid, type,
        revision,
        changed)
    SELECT
        i_uid, 'reindex',
        max(revision),
        json_agg(json_build_object('mid', mid))::jsonb
      FROM (
        SELECT mid, revision,
               row_number() OVER (ORDER BY revision) AS rn
          FROM mail.box
         WHERE uid = i_uid) mb
      GROUP BY ceil(rn/i_chunk_size);

    GET DIAGNOSTICS rc = ROW_COUNT;
    RETURN rc;

END;
$$ LANGUAGE plpgsql;
