CREATE OR REPLACE FUNCTION util.mailbox_size_dynamic(
    i_uid code.uid
) RETURNS bigint AS $$
DECLARE
    v_res         bigint := 0;
    v_table_name  text;
    v_table_size  bigint;
    v_query       text;
BEGIN
    FOR v_table_name in (
        SELECT format('%I.%I', table_schema, table_name)
          FROM information_schema.columns
         WHERE column_name = 'uid'
           AND table_name NOT LIKE 'change_log%'
           AND table_schema='mail')
    LOOP
        v_query := format(
            'SELECT sum(pg_column_size(t.*)) FROM %s t WHERE uid = $1',
            v_table_name);
        EXECUTE v_query INTO v_table_size USING i_uid;
        v_res := v_res + COALESCE(v_table_size, 0);
    END LOOP;
    RETURN v_res;
END;
$$ LANGUAGE plpgsql;
