CREATE OR REPLACE FUNCTION util.apply_data_migrations(
    i_uid code.uid,
    i_target_version integer DEFAULT constants.newest_data_version()
) RETURNS void AS $$
DECLARE
    v_current_data_version integer;
    v_migration_source_version integer;
    v_migration regproc;
BEGIN
    SELECT data_version
    INTO v_current_data_version
    FROM mail.users
    WHERE uid = i_uid;

    -- Check that apply_to_versions form number sequence from
    -- current data_version to prior-to-target data_version
    IF EXISTS (
        SELECT 1 FROM (
            SELECT apply_to_version,
                   row_number() over() + v_current_data_version - 1
                   AS expected_apply_to_version
              FROM constants.data_migrations()
             WHERE apply_to_version
               BETWEEN v_current_data_version
                   AND i_target_version - 1
        ) AS migration_versions
        WHERE apply_to_version != expected_apply_to_version
    ) THEN
        RAISE EXCEPTION 'apply_to_version for data migrations does not form '
            'sequence from % to %!', v_current_data_version, i_target_version - 1;
    END IF;

    FOR v_migration_source_version, v_migration IN (
        SELECT apply_to_version, migration_proc
          FROM constants.data_migrations()
         WHERE apply_to_version BETWEEN v_current_data_version AND i_target_version - 1
         ORDER BY apply_to_version
    ) LOOP
        RAISE NOTICE 'Running data migration % for uid %', v_migration, i_uid;
        EXECUTE 'SELECT ' || v_migration::text || '($1)' USING i_uid;
        v_current_data_version := v_current_data_version + 1;
    END LOOP;
    UPDATE mail.users
       SET data_version = v_current_data_version
     WHERE uid = i_uid;
END;
$$ LANGUAGE plpgsql;