/**
* Represents add_operation() function return value
*/
CREATE TYPE code.add_operation_result AS (
    inserted    boolean,        -- indicator of operation insertion success
    operation   mops.operations -- operation is related to the specified id
);

/**
* Represents message chunk as an argumet of a function
*
* @note There is a problem with the textual representation of a single element
*       tuple. PostgreSQL treats ARRAY[(ARRAY[1,2,3]), ...] like ARRAY[ARRAY[1,2,3], ...]
*       thus this leads to the chunk passing problems in psycopg2 and apq which we are using.
*       Double elements tuple text representation works well and ARRAY[(ARRAY[1,2,3], ''), ...]
*       works as expected. That's why the dummy element is introduced.
*/
CREATE TYPE code.messages_chunk AS (
    mids        bigint[], -- just mids of the chunk itself
    dummy       text      -- to avoid problems with single element tuple text representation
);
