/**
* Tries to setup operation into 'in_progress' state and store specified
* operation associated messages chunks if provided. In case of success
* given operation becomes 'in_progress'. Caller should check state of
* the returned operation to recognise if the call has been succeeded.
*
* @param i_op_id -- operation id
* @param i_chunks -- NULL or array of operation associated messages chunks
* @param i_request_id -- request id to be displayed in the changelog
*
* @return given operation in it's actual state.
*/
CREATE OR REPLACE FUNCTION code.process_operation (
    i_op_id         uuid,
    i_chunks        code.messages_chunk[],
    i_request_id    text)
RETURNS mops.operations AS $$
DECLARE
    v_op            mops.operations;
    v_chunks        mops.message_chunks;
BEGIN
    v_op := impl.transit_operation_state(i_op_id, 'process_operation', i_request_id);

    IF NOT v_op.state = 'in_progress' THEN
        RETURN v_op;
    END IF;

    IF i_chunks IS NULL THEN
        RETURN v_op;
    END IF;

    PERFORM impl.add_messages_chunk (i_op_id, x.id, x.mids, i_request_id) FROM
        (SELECT row_number() OVER () as id, mids FROM unnest(i_chunks)) AS x;

    RETURN v_op;
END;
$$ LANGUAGE plpgsql;
