/**
* Tries to mark an operation as it has been processed. In case of success
* given operation becomes 'complete'. The caller should check a state of
* the returned operation to recognize if the call has been succeeded. The
* operation cannot be marked as complete in case of at least one related
* chunk exists and is in state differs from 'done'. In this case, an
* exception will be thrown.
*
* @param i_op_id -- an operation id.
* @param i_request_id -- a request id to be displayed in the changelog.
*
* @return given operation in it's actual state.
*
* @throws in case of at least one chunk exists in non 'done' state.
*/
CREATE OR REPLACE FUNCTION code.process_operation_done (
    i_op_id         uuid,
    i_request_id    text)
RETURNS mops.operations AS $$
DECLARE
    v_op            mops.operations;
    v_chunk_ids     bigint[];
BEGIN
    v_op := impl.transit_operation_state(i_op_id, 'process_operation_done', i_request_id);

    -- If no desired state has been reached then should do nothing and return operation as it is
    IF NOT v_op.state = 'complete' THEN
        RETURN v_op;
    END IF;

    PERFORM impl.assert_chunks_state(i_op_id, 'done');

    RETURN v_op;
END;
$$ LANGUAGE plpgsql;
