/**
* Tries to mark an operation as it in end state and ready to be deleted.
* In case of success given operation becomes 'end'. The caller should
* check a state of the returned operation to recognize if the call has
* been succeeded.
*
* @param i_op_id -- an operation id.
* @param i_request_id -- a request id to be displayed in the changelog.
*
* @return given operation in it's actual state.
*
* @throws in case of no transition from current state has been found.
*/
CREATE OR REPLACE FUNCTION code.delete_operation (
    i_op_id         uuid,
    i_request_id    text)
RETURNS mops.operations AS $$
BEGIN
    return impl.transit_operation_state(i_op_id, 'delete_operation', i_request_id);
END;
$$ LANGUAGE plpgsql;
