/**
* Erases no more than specified count of operations with state 'end'.
* This function is supposed to be used in combination with code.delete_operation().
* The reason of such functional separation is to provide flexible mechanism to
* mark necessary operations as ready to delete in concurrent environment. And then
* purge only marked operations without any concurrency of possible state changing
* because 'end' state is the terminal state of the operation's state machine.
*
* @param i_count -- limit of operations to be removed.
*
* @return actual number of deleted entries.
*/
CREATE OR REPLACE FUNCTION code.purge_operations (
    i_count         int)
RETURNS int AS $$
DECLARE
    v_count         int;
BEGIN
    DELETE FROM mops.operations
        WHERE id IN (
            SELECT id
            FROM mops.operations
            WHERE state = 'end' LIMIT i_count FOR UPDATE SKIP LOCKED
        );
    GET DIAGNOSTICS v_count = ROW_COUNT;
    return v_count;
END;
$$ LANGUAGE plpgsql;
