/**
* Tries to mark operation to be reverted. In case of success
* given operation becomes 'in_revert' or 'reverted'. Caller
* should check a state of the returned operation to recognise
* if the call has been succeeded.
*
* @param i_op_id -- operation id
* @param i_request_id -- request id to be displayed in the changelog
*
* @return given operation in it's actual state.
*/
CREATE OR REPLACE FUNCTION code.undo_operation (
    i_op_id            uuid,
    i_request_id    text)
RETURNS mops.operations AS $$
BEGIN
    RETURN impl.transit_operation_state(i_op_id, 'undo_operation', i_request_id);
END;
$$ LANGUAGE plpgsql;
