/**
* Tries to mark an operation as it has been reverted. In case of success
* given operation becomes 'reverted'. The caller should check a state of
* the returned operation to recognize if the call has been succeeded. The
* operation cannot be marked as reverted in case of at least one related
* chunk exists and is in state differs from 'initial'. In this case, an
* exception will be thrown.
*
* @param i_op_id -- an operation id.
* @param i_request_id -- a request id to be displayed in the changelog.
*
* @return given operation in it's actual state.
*
* @throws in case of at least one chunk exists in non 'initial' state.
*/
CREATE OR REPLACE FUNCTION code.undo_operation_done (
    i_op_id         uuid,
    i_request_id    text)
RETURNS mops.operations AS $$
DECLARE
    v_op            mops.operations;
    v_chunk_ids     bigint[];
BEGIN
    v_op := impl.transit_operation_state(i_op_id, 'undo_operation_done', i_request_id);

    -- If no desired state has been reached then should do nothing and return operation as it is
    IF NOT v_op.state = 'reverted' THEN
        RETURN v_op;
    END IF;

    PERFORM impl.assert_chunks_state(i_op_id, 'initial');

    RETURN v_op;
END;
$$ LANGUAGE plpgsql;
