CREATE OR REPLACE FUNCTION code.release_lock (
    i_uid         bigint,
    i_launch_id   text)
RETURNS boolean AS $$
DECLARE
    v_existing_lock     operations.user_locks;
BEGIN
    -- Get existing lock for user to check if we can release it
    SELECT * INTO v_existing_lock
        FROM operations.user_locks
        WHERE uid = i_uid
        FOR UPDATE;

    IF NOT found THEN
        -- Realising non-acquired lock should return true (idempotency and etc.)
        RETURN true;
    END IF;

    IF v_existing_lock.launch_id = i_launch_id THEN
        -- Lock was acquired by the same caller, so we can release it
        DELETE FROM operations.user_locks
            WHERE uid = i_uid;

        -- Here we have successfully acquired lock, so we need to log this
        INSERT INTO operations.change_log (
                uid,
                TYPE,
                changed,
                hostname)
            VALUES (
                v_existing_lock.uid,
                'lock-release',
                row_to_json(v_existing_lock)::jsonb,
                v_existing_lock.hostname);

        RETURN true;

    END IF;

    RETURN false;

END;
$$ LANGUAGE plpgsql;
