# coding: utf-8

import yaml
from argparse import ArgumentParser, ArgumentDefaultsHelpFormatter

import mopsdb_cron


def main_program(cron_name, conf):
    cron = mopsdb_cron.get_cron(cron_name, conf)
    cron.run()


def main():
    parser = ArgumentParser('mopsdb-cron', formatter_class=ArgumentDefaultsHelpFormatter)
    parser.add_argument('--name', required=True, help='Cron to run')
    parser.add_argument('--config', required=True, help='Path to crons config')
    args = parser.parse_args()

    name = args.name
    with open(args.config, 'r') as cfg:
        config = yaml.safe_load(cfg)

    mopsdb_cron.init_logging(config, '{}.log'.format(name))

    main_program(name, config)

if __name__ == '__main__':
    main()
