# coding: utf-8

import logging
from .base_cron import BaseCron


class PgPartmanMaintenance(BaseCron):
    name = 'pg_partman_maintenance'
    logger = logging.getLogger(__name__)

    def __init__(self, conf):
        super(PgPartmanMaintenance, self).__init__(conf)

    def _run(self, conn):
        cur = conn.cursor()
        cur.execute('UPDATE part_config SET infinite_time_partitions=True;')
        conn.commit()
        cur.execute('SET lock_timeout to 0;')
        cur.execute('SELECT run_maintenance(NULL, FALSE, FALSE);')
        self.logger.info('Completed maintenance')
        cur.execute('SELECT parent_table FROM part_config;')
        tables = [i[0] for i in cur.fetchall()]
        for table in tables:
            cur.execute('ANALYZE %s;' % table)
            self.logger.info('Completed ANALYZE of %s', table)
        conn.commit()
