# coding: utf-8

import logging
from .base_cron import BaseCron


class QueueSizeUpdate(BaseCron):
    name = 'queue_size_update'
    logger = logging.getLogger(__name__)

    def __init__(self, conf):
        super(QueueSizeUpdate, self).__init__(conf)

    def _run(self, conn):
        queue_size = self._get_queue_size(conn)
        self._dump_queue_size(queue_size)
        self.logger.info('Completed stat update with {} total chunks'.format(queue_size))
        return queue_size

    @staticmethod
    def _get_queue_size(conn):
        cur = conn.cursor()
        cur.execute('SELECT count(*) FROM operations.chunks;')
        queue_size = cur.fetchone()[0]
        conn.commit()
        return queue_size

    def _dump_queue_size(self, queue_size):
        filename = self.conf.get('queue_size_file')
        if filename:
            with open(filename, 'w') as f:
                f.write(str(queue_size))
