# coding: utf-8

import logging
from .base_cron import BaseCron


class RemoveOldTasks(BaseCron):
    name = 'remove_old_tasks'
    logger = logging.getLogger(__name__)

    def __init__(self, conf):
        super(RemoveOldTasks, self).__init__(conf)

    def _run(self, conn):
        cur = conn.cursor()
        cur.execute('''
            DELETE FROM operations.tasks
            WHERE created < now() - '1 day'::interval
        ''')
        self.logger.info("Completed removing old tasks")
        cur.execute('''
            DELETE FROM operations.tasks t
            WHERE NOT EXISTS (SELECT 1 FROM operations.chunks c WHERE t.task_id=c.task_id)
        ''')
        self.logger.info('Completed removing empty tasks')
        conn.commit()
