# make 10 attempts in case of any problems
for i in {1..10}; do
    if [[ -d /ephemeral ]]; then
        mkdir -p /ephemeral/var/log/
        rsync -av /var/log/ /ephemeral/var/log/

        rm -rf /var/log

        ln -sf /ephemeral/var/log /var/log

        break
    else
        echo "Ephemeral not found, sleeping"
        sleep 5
    fi
done

if [[ "$i" -eq 10 ]]; then
    echo "[ERROR] Failed to link ephemeral, cannot start"
    exit 1
fi

# make 10 attempts in case of any problems
for i in {1..10}; do
    if [[ -f /secrets/.pgpass ]]; then
        echo "copying pgpass"
        cp -f /secrets/.pgpass /etc/yamail/.pgpass

        if [[ "$?" != 0 ]]; then
            continue
        fi

        echo "ok"
        break
    else
        echo "No pgpass found, sleeping"
        sleep 5
    fi
done

if [[ "$i" -eq 10 ]]; then
    echo "[ERROR] Failed to copy pgpass, cannot start"
    exit 1
fi

# make 10 attempts in case of any problems
for i in {1..10}; do
    if [[ -f /secrets/root.crt ]]; then
        echo "copying root.crt"
        cp -f /secrets/root.crt /etc/yamail/root.crt

        if [[ "$?" != 0 ]]; then
            continue
        fi

        echo "ok"
        break
    else
        echo "No root.crt found, sleeping"
        sleep 5
    fi
done

if [[ "$i" -eq 10 ]]; then
    echo "[ERROR] Failed to copy root.crt, cannot start"
    exit 1
fi

if [[ -z "${ENVIRONMENT_TYPE}" ]]; then
    echo "[ERROR] ENVIRONMENT_TYPE is not set, cannot start. Supported environments: production, prestable, testing"
    exit 1
fi

if [[ "${ENVIRONMENT_NAME}" ]]; then
    ENVIRONMENT="${ENVIRONMENT_NAME}-${ENVIRONMENT_TYPE}"
else
    ENVIRONMENT="${ENVIRONMENT_TYPE}"
fi

ln -sf /etc/mopsdb-cron/conf.yml-${ENVIRONMENT} /etc/mopsdb-cron/conf.yml
ln -sf /etc/nginx/sites-available/unistat.conf /etc/nginx/sites-enabled/unistat.conf
