from mail.devpack.lib.components.postgres import Postgres


class MopsDb(Postgres):
    NAME = "mopsdb"

    before_all_prefixes = [
        'resfs/file/mail/pg/mopsdb/drops',
    ]
    after_all_prefixes = [
        'resfs/file/mail/pg/mopsdb/impl',
        'resfs/file/mail/pg/mopsdb/code',
        'resfs/file/mail/pg/mopsdb/util',
        'resfs/file/mail/pg/mopsdb/grants',
    ]
    migration_prefixes = [
        'resfs/file/mail/pg/mopsdb/migrations',
    ]
    snapshot_sql_files = [
        'resfs/file/mail/pg/mopsdb/mopsdb.sql',
    ]

    def __init__(self, env, _):
        users = [
            'monitor',
            'mops',
            'tech',
        ]
        self.init_from_conf(env.get_config(), 'mopsdb', users)
