/*
* Returns operation row with exclusive lock for the row.
*
* @param i_id -- operation id
* @return operation row locked
* @throws exception if operation not found by given id
*/
CREATE OR REPLACE FUNCTION impl.acquire_operation(
    i_id             uuid
) RETURNS mops.operations AS $$
DECLARE
    v_row mops.operations;
BEGIN
    SELECT *
      INTO v_row
      FROM mops.operations
     WHERE id = i_id
       FOR NO KEY UPDATE;

    IF NOT found THEN
        RAISE EXCEPTION 'no operation found with id %', i_id
                  USING TABLE = 'mops.operations';
    END IF;

    RETURN v_row;
END;
$$ LANGUAGE plpgsql;