/**
* Chunk finite [automata](https://wiki.yandex-team.ru/SergejjXandrikov/UNDO/#chunkstate)
* implementation function. It returns table of automata transitions to select from using
* `from_state`, `action`.
*
* @return from_state -- current automata state
* @return action     -- action to apply to automata
* @return to_state   -- destination state
*/
CREATE OR REPLACE FUNCTION impl.chunk_transitions()
RETURNS TABLE (
    from_state mops.chunk_state,
    action     impl.chunk_action,
    to_state   mops.chunk_state
) AS $$
SELECT from_state::mops.chunk_state,
       action::impl.chunk_action,
       to_state::mops.chunk_state
  FROM (
    VALUES
        ('initial',     'process_chunk',        'in_progress'),

        ('in_progress', 'process_chunk_done',   'done'),
        ('in_progress', 'revert_chunk',         'in_revert'),

        ('in_revert',   'revert_chunk_done',    'initial'),

        ('done',        'revert_chunk',         'in_revert')
) AS t(from_state, action, to_state);
$$ LANGUAGE SQL IMMUTABLE;