/**
* Operation finite [automata](https://wiki.yandex-team.ru/SergejjXandrikov/UNDO/#operationstate)
* implementation function. It returns table of automata transitions to select from using
* `from_state`, `action` and `is_recent`.
*
* @return from_state -- current automata state
* @return action     -- action to apply to automata
* @return is_recent  -- operation is the last one between ones of current uid
* @return to_state   -- destination state
*/
CREATE OR REPLACE FUNCTION impl.operation_transitions()
RETURNS TABLE (
    from_state mops.operation_state,
    action     impl.operation_action,
    is_recent  boolean,
    to_state   mops.operation_state
) AS $$
SELECT from_state::mops.operation_state,
       action::impl.operation_action,
       is_recent,
       to_state::mops.operation_state
  FROM (
    VALUES
        ('fresh',           'process_operation',        NULL,   'in_progress'),

        ('fresh',           'undo_operation',           true,   'reverted'),
        ('fresh',           'undo_operation',           false,  'fresh'),

        ('in_progress',     'process_operation_done',   NULL,   'complete'),

        ('in_progress',     'undo_operation',           true,   'in_revert'),
        ('in_progress',     'undo_operation',           false,  'in_progress'),

        ('in_revert',       'process_operation_done',   NULL,   'in_revert'),

        ('in_revert',       'undo_operation_done',      NULL,   'reverted'),

        ('complete',        'undo_operation',           true,   'in_revert'),
        ('complete',        'undo_operation',           false,  'complete'),

        ('complete',        'delete_operation',         false,  'end'),
        ('complete',        'delete_operation',         true,   'complete'),

        ('reverted',        'delete_operation',         NULL,   'end')
) AS t(from_state, action, is_recent, to_state);
$$ LANGUAGE SQL IMMUTABLE;