/**
* Writes change_log entry for the specified change.
*
* @param i_type -- change type
* @param i_uid -- user id for which operation change is made
* @param i_changed -- json with change specific data
* @param i_request_id -- database query request id
*/
CREATE OR REPLACE FUNCTION impl.write_change_log (
    i_type          mops.change_type,
    i_uid           bigint,
    i_op_id         uuid,
    i_changed       jsonb,
    i_request_id    text)
RETURNS void AS $$
BEGIN
    INSERT INTO mops.change_log (uid, type, op_id, changed, request_id)
        VALUES (i_uid, i_type, i_op_id, i_changed, i_request_id);
END;
$$ LANGUAGE plpgsql;
