/**
* Add messages chunk for specified operation and writes changelog entry
* for the chunk.
*
* @param i_op_id -- operation id
* @param i_id -- chunk id, must be unique for the same i_op_id
* @param i_mids -- array of mids to be processed as single chunk
* @param i_request_id -- request id to be displayed in the changelog.
*/
CREATE OR REPLACE FUNCTION impl.add_messages_chunk (
    i_op_id         uuid,
    i_id            bigint,
    i_mids          bigint[],
    i_request_id    text)
RETURNS void AS $$
DECLARE
    v_uid bigint;
BEGIN
    SELECT uid
      INTO v_uid
      FROM mops.operations
     WHERE id = i_op_id;

    IF NOT found THEN
        RAISE EXCEPTION 'no operation found with id %', i_op_id
                  USING TABLE = 'mops.operations';
    END IF;

    INSERT INTO mops.message_chunks (id, op_id, mids)
        VALUES (i_id, i_op_id, i_mids);

    PERFORM impl.write_change_log (
        i_type          => 'chunk_create'::mops.change_type,
        i_uid           => v_uid,
        i_op_id         => i_op_id,
        i_changed       => json_build_object(
                                'id', i_id,
                                'count', cardinality(i_mids)
                            )::jsonb,
        i_request_id    => i_request_id
    );
END;
$$ LANGUAGE plpgsql;