/**
* Checks all operation-related chunks' state to be equal to the given state.
* If a chunk with different from the given state is found then an exception
* will be thrown.
*
* @param i_op_id -- an operation id.
* @param i_state -- the given state.
*
* @throws in case of chunk with different state found.
*/
CREATE OR REPLACE FUNCTION impl.assert_chunks_state (
    i_op_id         uuid,
    i_state         mops.chunk_state)
RETURNS void AS $$
DECLARE
    v_chunk_ids     bigint[];
BEGIN
    SELECT INTO v_chunk_ids ARRAY(SELECT id
      FROM mops.message_chunks
     WHERE op_id = i_op_id AND NOT state = i_state);

    IF CARDINALITY(v_chunk_ids) > 0 THEN
        RAISE EXCEPTION 'found chunks % are not in % state', v_chunk_ids, i_state
                  USING TABLE = 'mops.message_chunks';
    END IF;
END;
$$ LANGUAGE plpgsql;