CREATE SCHEMA IF NOT EXISTS operations;

CREATE TABLE operations.tasks (
    task_id uuid NOT NULL,
    uid bigint NOT NULL,
    task_info json NOT NULL,
    created timestamp with time zone NOT NULL DEFAULT current_timestamp,
    CONSTRAINT pk_tasks PRIMARY KEY (
        task_id ) );

CREATE INDEX i_task_uid ON operations.tasks (
    uid );

CREATE TABLE operations.chunks (
    chunk_id uuid NOT NULL,
    task_id uuid NOT NULL REFERENCES operations.tasks (
        task_id )
    ON DELETE CASCADE,
    created timestamp with time zone NOT NULL DEFAULT current_timestamp,
    CONSTRAINT pk_chunks PRIMARY KEY (
        chunk_id ) );

CREATE TABLE operations.mids (
    mid bigint,
    chunk_id uuid NOT NULL REFERENCES operations.chunks (
        chunk_id )
    ON DELETE CASCADE,
    CONSTRAINT pk_mids PRIMARY KEY (
        chunk_id,
        mid ) );

CREATE INDEX i_mids_mid ON operations.mids (
    mid );

CREATE TABLE operations.banned_users (
    uid bigint NOT NULL,
    CONSTRAINT pk_users PRIMARY KEY (
        uid ) );

CREATE TABLE operations.recent_tasks (
    task_id uuid NOT NULL,
    SIZE bigint NOT NULL,
    created timestamp with time zone NOT NULL DEFAULT current_timestamp,
    uid bigint NOT NULL,
    CONSTRAINT pk_recent_tasks PRIMARY KEY (
        task_id ) );

CREATE INDEX i_recent_task_uid ON operations.recent_tasks (
    uid );
