CREATE sequence operations.cid_seq START WITH 1 INCREMENT BY
    1 CYCLE;

CREATE TYPE operations.change_type AS enum (
    'delete-chunk' );

CREATE TABLE operations.change_log (
    cid         bigint NOT NULL DEFAULT NEXTVAL ('operations.cid_seq'),
    change_date timestamp with time zone NOT NULL DEFAULT current_timestamp,
    uid         bigint NOT NULL,
    TYPE        operations.change_type NOT NULL,
    changed     jsonb,
    hostname    text NOT NULL
) PARTITION BY RANGE(change_date);

CREATE TABLE operations.change_log_templ (
    LIKE operations.change_log INCLUDING DEFAULTS
);

ALTER TABLE operations.change_log_templ
    ADD CONSTRAINT pk_change_log_templ PRIMARY KEY (cid);

CREATE extension IF NOT EXISTS pg_partman SCHEMA public;

SELECT create_parent (
    p_parent_table := 'operations.change_log',
    p_template_table := 'operations.change_log_templ',
    p_control := 'change_date',
    p_type := 'native',
    p_interval := 'daily',
    p_premake := 5,
    p_jobmon := false
);

UPDATE part_config
   SET retention = '7 days',
       retention_keep_table = false,
       retention_keep_index = false
 WHERE parent_table = 'operations.change_log';
