CREATE TABLE operations.user_locks (
    uid            bigint NOT NULL,
    ttl            interval NOT NULL,
    heartbeated    timestamp with time zone NOT NULL DEFAULT current_timestamp,
    assigned       timestamp with time zone NOT NULL DEFAULT current_timestamp,
    launch_id      text NOT NULL,
    hostname       text,

    CONSTRAINT pk_user_locks PRIMARY KEY (uid)
);

CREATE OR REPLACE FUNCTION operations.expiration_date(
    i_heartbeated   timestamp with time zone,
    i_ttl           interval
) RETURNS timestamp with time zone AS $$
    SELECT (i_heartbeated + i_ttl);
$$ LANGUAGE SQL IMMUTABLE STRICT;

CREATE INDEX i_operations_user_locks_uid_old
    ON operations.user_locks (uid, operations.expiration_date(heartbeated, ttl));
