CREATE OR REPLACE FUNCTION util.force_release_lock (
    i_uid         bigint)
RETURNS boolean AS $$
DECLARE
    v_released_lock     operations.user_locks;
BEGIN
    DELETE FROM operations.user_locks
        WHERE uid = i_uid
        RETURNING * INTO v_released_lock;

    IF found THEN
        INSERT INTO operations.change_log (
                uid,
                TYPE,
                changed,
                hostname)
            VALUES (
                v_released_lock.uid,
                'lock-delete',
                row_to_json(v_released_lock)::jsonb,
                v_released_lock.hostname);

        RETURN true;
    END IF;

    RETURN false;

END;
$$ LANGUAGE plpgsql;
