CREATE OR REPLACE FUNCTION code.acquire_tasks(
    i_worker            text,
    i_tasks_limit       integer
)  RETURNS SETOF queue.tasks as $$

UPDATE queue.tasks
   SET state = 'in_progress',
       processing_date = current_timestamp,
       worker = i_worker,
       reassignment_count = CASE WHEN state = 'in_progress'
                                 THEN reassignment_count + 1
                                 ELSE reassignment_count 
                             END
 WHERE task_id IN (
    SELECT task_id
      FROM queue.tasks qt
     WHERE service = current_user
       AND (
            (state = 'pending' AND processing_date < current_timestamp) OR
            (state = 'in_progress' AND queue.expiration_date(processing_date, timeout) < current_timestamp)
       )
  ORDER BY processing_date
     LIMIT i_tasks_limit 
       FOR UPDATE
      SKIP LOCKED
) 
RETURNING *;

$$ LANGUAGE SQL;
