CREATE OR REPLACE FUNCTION code.complete_task(
    i_task_id           bigint,
    i_worker            text
)  RETURNS void as $$
BEGIN
    WITH deleted_tasks AS (
        DELETE FROM queue.tasks
         WHERE task_id = i_task_id
           AND service = current_user
           AND state = 'in_progress'
           AND worker = i_worker 
     RETURNING *
    )
    INSERT INTO queue.processed_tasks
           (task_id, uid, service, task, state, task_args, reassignment_count, tries, try_notices,
            created, processing_date, timeout, worker)
    SELECT task_id, uid, service, task, 'complete', task_args, reassignment_count, tries, try_notices,
            created, current_timestamp, timeout, worker
      FROM deleted_tasks;

    IF NOT found THEN
        RAISE EXCEPTION 'can not update task';
    END IF;
END;
$$ LANGUAGE plpgsql;
