CREATE OR REPLACE FUNCTION code.fail_task(
    i_task_id           bigint,
    i_worker            text,
    i_reason            text,
    i_max_retries       integer,
    i_delay             interval DEFAULT '1 sec'
)  RETURNS void as $$
DECLARE
    curr_tries integer;
BEGIN
    SELECT tries
      FROM queue.tasks
     WHERE task_id = i_task_id
       AND service = current_user
       AND state = 'in_progress'
       AND worker = i_worker
       FOR UPDATE
      INTO curr_tries;

    IF NOT found THEN
        RAISE EXCEPTION 'can not update task';
    END IF;

    IF curr_tries >= i_max_retries THEN
        WITH deleted_tasks AS (
            DELETE FROM queue.tasks
             WHERE task_id = i_task_id
         RETURNING *
        )
        INSERT INTO queue.processed_tasks
               (task_id, uid, service, task, state, task_args, reassignment_count, tries, try_notices,
                created, processing_date, timeout, worker)
        SELECT task_id, uid, service, task, 'error', task_args, reassignment_count, tries, array_append(try_notices, i_reason),
                created, current_timestamp, timeout, worker
          FROM deleted_tasks;
    ELSE
        UPDATE queue.tasks
           SET state = 'pending',
               tries = tries + 1,
               try_notices = array_append(try_notices, i_reason),
               processing_date = current_timestamp + i_delay
         WHERE task_id = i_task_id;
    END IF;

    IF NOT found THEN
        RAISE EXCEPTION 'can not update task';
    END IF;
END;
$$ LANGUAGE plpgsql;
