CREATE OR REPLACE FUNCTION code.refresh_task(
    i_task_id           bigint,
    i_worker            text
)  RETURNS void as $$
BEGIN
    UPDATE queue.tasks
       SET processing_date = current_timestamp
     WHERE task_id = i_task_id
       AND service = current_user
       AND state = 'in_progress'
       AND worker = i_worker;

    IF NOT found THEN
        RAISE EXCEPTION 'can not update task';
    END IF;
END;
$$ LANGUAGE plpgsql;
