from mail.devpack.lib.components.postgres import Postgres


class QueueDb(Postgres):
    NAME = "queuedb"

    before_all_prefixes = [
        'resfs/file/mail/pg/queuedb/devpack/extensions.sql',
    ]

    after_all_prefixes = [
        'resfs/file/mail/pg/queuedb/code',
        'resfs/file/mail/pg/queuedb/grants',
        'resfs/file/mail/pg/queuedb/devpack/grants.sql',
    ]
    migration_prefixes = [
        'resfs/file/mail/pg/queuedb/migrations',
    ]
    snapshot_sql_files = [
        'resfs/file/mail/pg/queuedb/queue.sql',
    ]

    def __init__(self, env, _):
        users = [
            'queuedb',
            'barbet',
            'spaniel',
            'tech',
        ]
        self.init_from_conf(env.get_config(), 'queuedb', users)
