from os import environ

from mail.python.theatre.app.settings import SettingsNode


class QueueDbSettings(SettingsNode):
    base_dsn: str = None
    base_dsn_ro: str = None

    def pg_dsn(self, user: str, ro: bool = False, **kwargs) -> str:
        conn_args = dict(
            user=user,
        )
        conn_args.update(kwargs)
        extra_params = ' '.join((f'{arg_name}={arg_val}' for arg_name, arg_val in conn_args.items()))

        if ro:
            return f"{self.base_dsn_ro} {extra_params}"
        else:
            return f"{self.base_dsn} {extra_params}"

    def prod(self):
        self.base_dsn = ' '.join((
            'host=sas-d16hhyke6v6452a6.db.yandex.net,vla-i1tctddf468cprfv.db.yandex.net,man-p1gao51fcm2g0e4v.db.yandex.net',
            'port=6432',
            'dbname=queuedb',
            'target_session_attrs=read-write',
        ))
        self.base_dsn_ro = ' '.join((
            'host=c-mdbvd6rdmijd2tkjr509.ro.db.yandex.net',
            'port=6432',
            'dbname=queuedb',
        ))

    def test(self):
        self.base_dsn = ' '.join((
            'host=sas-qanz2y39eegp3208.db.yandex.net,vla-20c2rwtgz76tq4q8.db.yandex.net,man-7bdj8nc3nxu7olgs.db.yandex.net',
            'port=6432',
            'dbname=queuedb',
            'target_session_attrs=read-write',
        ))
        self.base_dsn_ro = ' '.join((
            'host=c-mdb1asfv04n0eo6pm1m2.ro.db.yandex.net',
            'port=6432',
            'dbname=queuedb',
        ))

    def devpack(self):
        self.base_dsn = f"host=localhost port={environ['DEVPACK_QUEUEDB_PORT']} dbname=queuedb"
        self.base_dsn_ro = f"host=localhost port={environ['DEVPACK_QUEUEDB_PORT']} dbname=queuedb"
