CREATE OR REPLACE FUNCTION code.add_instance(
    i_primary_host text,
    i_host text,
    i_port integer,
    i_dc text,
    i_dbname text
)  RETURNS integer as $$
DECLARE
    l_shard_id integer;
BEGIN
    INSERT INTO shards.instances
        (instance_id,
        shard_id,
        host,
        port,
        dc,
        dbname)
    SELECT (nextval('shards.instance_s')),
        s.shard_id,
        i_host,
        i_port,
        i_dc,
        i_dbname
      FROM shards.instances i INNER
      JOIN shards.shards s
        ON (i.shard_id=s.shard_id)
     WHERE i.host=i_primary_host
      AND NOT EXISTS
      (SELECT 1 FROM shards.instances WHERE host=i_host)
    RETURNING shard_id INTO l_shard_id;

    IF NOT FOUND THEN
        RAISE NOTICE 'Instance already exists.';
    END IF;

    RETURN l_shard_id;
END;
$$ LANGUAGE plpgsql;

CREATE OR REPLACE FUNCTION code.add_instance(
    i_shard_id integer,
    i_instance code.instance
)  RETURNS integer as $$
DECLARE
    l_instance_id integer;
BEGIN
    SELECT instance_id INTO l_instance_id
      FROM shards.instances
     WHERE shard_id = i_shard_id
       AND host = i_instance.host;
    IF found THEN
        RAISE NOTICE 'Instance already exists.';
    ELSE
        INSERT INTO shards.instances(
            instance_id,
            shard_id,
            host,
            port,
            dc,
            dbname
        )
        SELECT
            nextval('shards.instance_s'),
            i_shard_id,
            i_instance.host,
            i_instance.port,
            i_instance.dc,
            i_instance.dbname
        RETURNING instance_id INTO l_instance_id;
    END IF;

    RETURN l_instance_id;
END;
$$ LANGUAGE plpgsql;
