CREATE OR REPLACE FUNCTION code.create_domain(
    i_domain_id bigint,
    i_shard_id integer
) RETURNS integer AS $$
DECLARE
    inserted integer;
    real_shard_id integer;
BEGIN
    INSERT INTO shards.domains_organizations (domain_id, shard_id)
    VALUES (i_domain_id, i_shard_id)
    ON CONFLICT DO NOTHING
    RETURNING shard_id INTO real_shard_id;

    GET DIAGNOSTICS inserted = ROW_COUNT;

    IF inserted = 0 THEN
        SELECT shard_id
          FROM shards.domains_organizations
         WHERE domain_id = i_domain_id
          INTO real_shard_id;

        IF NOT FOUND THEN
            RAISE EXCEPTION 'Can''t add domain domain_id=%, shard_id=%', i_domain_id, i_shard_id;
        END IF;
    END IF;

    RETURN real_shard_id;
END;
$$ LANGUAGE plpgsql;
