CREATE OR REPLACE FUNCTION code.create_organization(
    i_org_id bigint,
    i_domain_id bigint,
    i_shard_id integer
) RETURNS integer AS $$
DECLARE
    inserted integer;
    real_shard_id integer;
BEGIN
    SELECT shard_id
      FROM shards.domains_organizations
     WHERE domain_id = i_domain_id
       AND org_id IS NULL
      INTO real_shard_id;

    IF FOUND THEN
        UPDATE shards.domains_organizations
           SET org_id = i_org_id
         WHERE domain_id = i_domain_id
           AND org_id IS NULL;
        RETURN real_shard_id;
    END IF;

    INSERT INTO shards.domains_organizations (org_id, domain_id, shard_id)
    VALUES (i_org_id, i_domain_id, i_shard_id)
    ON CONFLICT DO NOTHING
    RETURNING shard_id INTO real_shard_id;

    GET DIAGNOSTICS inserted = ROW_COUNT;

    IF inserted = 0 THEN
        SELECT shard_id
          FROM shards.domains_organizations
         WHERE org_id = i_org_id
          INTO real_shard_id;

        IF NOT FOUND THEN
            RAISE EXCEPTION 'Can''t add organization org_id=%, domain_id=%, shard_id=%',
                i_org_id, i_domain_id, i_shard_id;
        END IF;
    END IF;

    RETURN real_shard_id;
END;
$$ LANGUAGE plpgsql;
