CREATE OR REPLACE FUNCTION code.move_user_to_deleted(
    i_uid bigint
) RETURNS code.update_user_result AS $$
DECLARE
BEGIN
    if exists (
        SELECT 1 from shards.deleted_users where uid = i_uid
    ) then
        return 'success';
    end if;
    WITH with_deleted AS (
        DELETE
          FROM shards.users
         WHERE uid = i_uid
        RETURNING *
    )
    INSERT INTO shards.deleted_users
    SELECT uid, shard_id, data FROM with_deleted;

    IF NOT found THEN
        RETURN 'user_not_found';
    END IF;

    RETURN 'success';
END;
$$ LANGUAGE plpgsql;
