CREATE OR REPLACE FUNCTION code.register_user(
    i_uid bigint,
    i_shard_id integer
) RETURNS code.registration_result AS $$
DECLARE
BEGIN
    IF NOT pg_try_advisory_xact_lock(i_uid) THEN
        RETURN 'already_in_progress';
    END IF;

    IF EXISTS (
        SELECT 1
          FROM shards.users
         WHERE uid = i_uid
    ) THEN
        RETURN 'already_registered';
    END IF;

    WITH with_deleted AS (
        DELETE
          FROM shards.deleted_users
         WHERE uid = i_uid
        RETURNING *
    )
    INSERT INTO shards.users
    SELECT uid, shard_id, data FROM with_deleted;

    IF NOT found THEN
        INSERT INTO shards.users (uid, shard_id)
        VALUES (i_uid, i_shard_id);
    END IF;

    RETURN 'success';
END;
$$ LANGUAGE plpgsql;
