CREATE OR REPLACE FUNCTION code.add_cluster(
    i_shard_name text,
    i_load_type shards.load_types,
    i_instances code.instance[]
)  RETURNS integer as $$
DECLARE
    l_instance code.instance;
    l_shard_id integer;
BEGIN
    SELECT shard_id INTO l_shard_id
      FROM shards.shards
     WHERE name = i_shard_name;
    IF found THEN
        RAISE NOTICE 'Shard already exists.';
    ELSE
        INSERT INTO shards.shards
        (SELECT
            nextval('shards.shard_s'),
            i_shard_name,
            i_load_type
        )
        RETURNING shard_id INTO l_shard_id;
    END IF;

    FOR l_instance IN (select * from unnest(i_instances)) LOOP
        PERFORM code.add_instance(l_shard_id, l_instance);
    END LOOP;

    RETURN l_shard_id;
END;
$$ LANGUAGE plpgsql;
