CREATE SEQUENCE shards.shard_s;

CREATE SEQUENCE shards.instance_s;

ALTER TABLE shards.instances ADD CONSTRAINT U_INSTANCE_HOSTNAME UNIQUE (host);

CREATE OR REPLACE FUNCTION shards.add_shard(
    i_host text,
    i_port integer,
    i_dc text,
    i_dbname text
)  RETURNS integer as $$
DECLARE
    l_shard_id integer;
BEGIN
    INSERT INTO shards.shards
    SELECT
        (nextval('shards.shard_s'))
    WHERE NOT EXISTS (
        SELECT 1
          FROM shards.instances
         WHERE  host=i_host)
    RETURNING shard_id INTO l_shard_id;

    IF FOUND THEN
        INSERT INTO shards.instances
            (instance_id,
            shard_id,
            host,
            port,
            dc,
            dbname)
        VALUES
            (nextval('shards.instance_s'),
            l_shard_id,
            i_host,
            i_port,
            i_dc,
            i_dbname);

    ELSE
        RAISE NOTICE 'Shard already exists.';

        SELECT shard_id
          INTO l_shard_id
          FROM shards.instances
         WHERE  host=i_host;
    END IF;

    RETURN l_shard_id;
END;
$$ LANGUAGE plpgsql;

CREATE OR REPLACE FUNCTION shards.add_instance(
    i_primary_host text,
    i_host text,
    i_port integer,
    i_dc text,
    i_dbname text
)  RETURNS integer as $$
DECLARE
    l_shard_id integer;
BEGIN
    INSERT INTO shards.instances
        (instance_id,
        shard_id,
        host,
        port,
        dc,
        dbname)
    SELECT (nextval('shards.instance_s')),
        s.shard_id,
        i_host,
        i_port,
        i_dc,
        i_dbname
      FROM shards.instances i INNER
      JOIN shards.shards s
        ON (i.shard_id=s.shard_id)
     WHERE i.host=i_primary_host
      AND NOT EXISTS
      (SELECT 1 FROM shards.instances WHERE host=i_host)
    RETURNING shard_id INTO l_shard_id;

    IF NOT FOUND THEN
        RAISE NOTICE 'Instance already exists.';
    END IF;

    RETURN l_shard_id;
END;
$$ LANGUAGE plpgsql;
