CREATE TABLE transfer.info (
    uid bigint,
    suid bigint,
    from_db text,
    to_db text,
    transfer_start timestamp with time zone,
    transfer_end timestamp with time zone,
    script text,
    script_revision text,
    transfer_host text,
    CONSTRAINT pk_transfer_info PRIMARY KEY (uid, transfer_start, transfer_end)
);

INSERT INTO transfer.info (
    SELECT uid, suid, mdb, NULL, transfer_start, transfer_end,
        script, script_revision, transfered_at
      FROM transfer.transfer_info
);

ALTER TABLE transfer.transfer_info RENAME TO old_transfer_info;
ALTER TABLE transfer.old_transfer_info SET SCHEMA public;
