CREATE SEQUENCE transfer.huskies_s;

CREATE TYPE transfer.husky_status AS ENUM (
    'running',
    'sleeping',
    'dead'
);

CREATE TABLE transfer.huskies (
    husky_id     integer NOT NULL,
    host         text,
    status       transfer.husky_status    NOT NULL DEFAULT 'sleeping',
    heartbeated  timestamp with time zone NOT NULL DEFAULT current_timestamp,
    usercount    integer NOT NULL DEFAULT 0,

    CONSTRAINT pk_husies PRIMARY KEY (husky_id)
);

CREATE TYPE transfer.user_status AS ENUM (
    'pending',
    'in_transfer',
    'error',
    'complete'
);

CREATE TABLE transfer.users_in_dogsleds (
    uid         bigint   NOT NULL,
    to_db       text     NOT NULL,
    disallow_inited       boolean NOT NULL DEFAULT false,
    fill_change_log       boolean NOT NULL DEFAULT false,
    update_mail_migration boolean NOT NULL DEFAULT false,

    priority    smallint NOT NULL DEFAULT 0,
    husky_id    integer,

    tries       smallint NOT NULL DEFAULT 0,
    status      transfer.user_status     NOT NULL DEFAULT 'pending',
    last_update timestamp with time zone NOT NULL DEFAULT current_timestamp,
    try_notices text[],

    CONSTRAINT check_tries CHECK (tries >= 0),
    CONSTRAINT check_status CHECK (status = 'pending' OR husky_id IS NOT NULL),

    CONSTRAINT pk_users_in_dogsleds PRIMARY KEY (uid),
    CONSTRAINT fk_users_in_dogsleds_and_huskies FOREIGN KEY (husky_id)
        REFERENCES transfer.huskies ON DELETE RESTRICT
);

CREATE INDEX i_users_in_dogsleds_by_husky_id_prioretized_pending
    ON transfer.users_in_dogsleds (husky_id, priority, last_update)
 WHERE status = 'pending';

CREATE INDEX i_users_in_dogsleds_by_husky_id_in_transfer
    ON transfer.users_in_dogsleds (husky_id)
 WHERE status = 'in_transfer';

COMMENT ON COLUMN transfer.users_in_dogsleds.priority
    IS 'lowest priority = first to transfer';
